<?php
/* ==============================================
 * CSS AND JAVASCRIPT USED IN THIS MODEL
 * ==============================================
 */
$stylesheets[] = array("file" => DOCBASE."js/plugins/royalslider/royalslider.css", "media" => "all");
$stylesheets[] = array("file" => DOCBASE."js/plugins/royalslider/skins/minimal-white/rs-minimal-white.css", "media" => "all");
$javascripts[] = DOCBASE."js/plugins/royalslider/jquery.royalslider.min.js";

$stylesheets[] = array("file" => DOCBASE."js/plugins/isotope/css/style.css", "media" => "all");
$javascripts[] = DOCBASE."js/plugins/isotope/jquery.isotope.min.js";
$javascripts[] = DOCBASE."js/plugins/isotope/jquery.isotope.sloppy-masonry.min.js";

require(SYSBASE."templates/".TEMPLATE."/common/header.php");

$slide_id = 0;
$result_slide_file = $db->prepare("SELECT * FROM pm_slide_file WHERE id_item = :slide_id AND checked = 1 AND lang = ".DEFAULT_LANG." AND type = 'image' AND file != '' ORDER BY rank LIMIT 1");
$result_slide_file->bindParam("slide_id", $slide_id);

$result_slide = $db->query("SELECT * FROM pm_slide WHERE id_page = ".$page_id." AND checked = 1 AND lang = ".LANG_ID." ORDER BY rank", PDO::FETCH_ASSOC);
if($result_slide !== false){
	$nb_slides = $db->last_row_count();
	if($nb_slides > 0){ ?>
	
		<section class="clearfix hidden-xs">
            <div class="royalSlider heroSlider rsMinW sliderContainer fullWidth clearfix">
                <?php
                foreach($result_slide as $i => $row){
                    $slide_id = $row['id'];
                    $slide_legend = $row['legend'];
                    $url_video = $row['url'];
                    $id_page = $row['id_page'];
                    
                    $result_slide_file->execute();
                    
                    if($result_slide_file !== false && $db->last_row_count() == 1){
                        $row = $result_slide_file->fetch();
                        
                        $file_id = $row['id'];
                        $filename = $row['file'];
                        $label = $row['label'];
                        
                        $realpath = SYSBASE."medias/slide/big/".$file_id."/".$filename;
                        $thumbpath = DOCBASE."medias/slide/small/".$file_id."/".$filename;
                        $zoompath = DOCBASE."medias/slide/big/".$file_id."/".$filename;
                            
                        if(is_file($realpath)){ ?>
                        
                            <div class="rsContent">
                                <img class="rsImg" src="<?php echo $zoompath; ?>" alt=""<?php if($url_video != "") echo " data-rsVideo=\"".$url_video."\""; ?>>
                                <?php
                                if($slide_legend != ""){ ?>
                                    <div class="infoBlock" data-fade-effect="" data-move-offset="10" data-move-effect="bottom" data-speed="200">
                                        <?php echo $slide_legend; ?>
                                    </div>
                                    <?php
                                } ?>
                            </div>
                            <?php
                        }
                    }
                } ?>
            </div>
		</section>
		<?php
	}
} ?>
<section id="content" class="pb30">
    <div class="container">
        <div class="row">
            <div class=" text-center mb20">
                <h1 itemprop="name"><?php echo $page['title']; ?></h1>
                <?php
                if($page['subtitle'] != ""){ ?>
                    <h2><?php echo $page['subtitle']; ?></h2>
                    <?php
                } ?>
            </div>
            <?php
            if($page['text'] != ""){
                $text_page = explode("<hr />",$page['text']);
                foreach($text_page as $i => $content){ ?>
                    <div class="col-md-4">
                        <article class="iconBlocHome<?php if(RTL_DIR) echo " rtl"; ?>">
                            <i class="fa fa-check"></i>
                            <?php echo $content; ?>
                        </article>
                    </div>
                    <?php
                }
            } ?>
        </div>
        <div class="row">
            <?php
            $result_article = $db->query("SELECT * FROM pm_article WHERE (id_page = ".$page_id." OR home = 1) AND checked = 1 AND (publish_date IS NULL || publish_date <= ".time().") AND (unpublish_date IS NULL || unpublish_date > ".time().") AND lang = ".LANG_ID." ORDER BY rank");
            if($result_article !== false){
                $nb_articles = $db->last_row_count();
                
                if($nb_articles > 0){ ?>
                    <div class="isotopeWrapper clearfix isotope mt20">
                        <?php
                        $article_id = 0;
                        $result_article_file = $db->prepare("SELECT * FROM pm_article_file WHERE id_item = :article_id AND checked = 1 AND lang = ".DEFAULT_LANG." AND type = 'image' AND file != '' ORDER BY rank LIMIT 1");
                        $result_article_file->bindParam(":article_id",$article_id);
                        foreach($result_article as $i => $row){
                            $article_id = $row['id'];
                            $article_title = $row['title'];
                            $article_alias = $row['alias'];
                            $article_text = strtrunc(strip_tags($row['text']),170);
                            $article_tags = $row['tags'];
                            $article_page = $row['id_page'];
                            
                            if($article_tags != "") $article_tags = " tag".str_replace(","," tag",$article_tags);
                            
                            if(isset($pages[$article_page])){
                            
                                $article_alias = DOCBASE.$pages[$article_page]['alias']."/".text_format($article_alias); ?>
                                
                                <article class="article-<?php echo $article_id; ?> col-sm-4 isotopeItem<?php echo $article_tags; ?>" itemscope itemtype="http://schema.org/Article">
                                    <div class="isotopeInner">
                                        <a itemprop="url" href="<?php echo $article_alias; ?>" class="moreLink">
                                            <?php
                                            if($result_article_file->execute() !== false && $db->last_row_count() == 1){
                                                $row = $result_article_file->fetch(PDO::FETCH_ASSOC);
                                                
                                                $file_id = $row['id'];
                                                $filename = $row['file'];
                                                $label = $row['label'];
                                                
                                                $realpath = SYSBASE."medias/article/small/".$file_id."/".$filename;
                                                $thumbpath = DOCBASE."medias/article/small/".$file_id."/".$filename;
                                                $zoompath = DOCBASE."medias/article/big/".$file_id."/".$filename;
                                                
                                                if(is_file($realpath)){ ?>
                                                    <figure class="more-link">
                                                        <img alt="<?php echo $label; ?>" src="<?php echo $thumbpath; ?>" class="img-responsive">
                                                        <span class="more-action">
                                                            <span class="more-icon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                                        </span>
                                                    </figure>
                                                    <?php
                                                }
                                            } ?>
                                            <div class="isotopeContent">
                                                <h3 itemprop="name"><?php echo $article_title; ?></h3>
                                                <p>
                                                    <?php echo $article_text; ?>
                                                </p>
                                                <i class="fa fa-caret-right"></i> <?php echo $texts['READMORE']; ?>
                                            </div>
                                        </a>
                                    </div>
                                </article>
                                <?php
                            }
                        } ?>
                    </div>
                    <?php
                }
            } ?>
        </div>
    </div>
</section>
