-- SQL SCRIPT FOR THE DATABASE OF PANDAO CMS

-- **** Values to replace ****
-- MY_DATABASE
-- MY_DB_USER
-- MY_DB_PASS
-- USER_EMAIL
-- USER_LOGIN
-- USER_PASS
-- INSTALL_DATE

-- **** Tables ****
-- pm_user
-- pm_lang
-- pm_lang_file
-- pm_page
-- pm_page_file
-- pm_media
-- pm_media_file
-- pm_text
-- pm_widget
-- pm_article
-- pm_article_file
-- pm_comment
-- pm_tag
-- pm_slide
-- pm_slide_file
-- pm_location
-- pm_message
-- pm_currency
-- pm_country

-- **** Edit with the name of your database ****
CREATE DATABASE IF NOT EXISTS MY_DATABASE;
USE MY_DATABASE;

-- **** Uncomment the following line if you are allowed to create users ****
-- GRANT SELECT, INSERT, UPDATE, DELETE ON MY_DATABASE.* TO 'MY_DB_USER'@'localhost' IDENTIFIED BY 'MY_DB_PASS' WITH MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0;

-- ================= CREATION OF THE TABLE pm_user ===============

CREATE TABLE IF NOT EXISTS pm_user(
    id int NOT NULL AUTO_INCREMENT,
    name varchar(100),
    email varchar(100),
    login varchar(50),
    pass varchar(100),
    type varchar(20),
    add_date int,
    edit_date int,
    checked int DEFAULT 0,
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

-- **** Edit with the informations of the admin user ****
INSERT INTO pm_user (id, name, email, login, pass, type, add_date, edit_date, checked) VALUES
(1, 'Administrator', 'USER_EMAIL', 'USER_LOGIN', 'USER_PASS', 'administrator', INSTALL_DATE, INSTALL_DATE, 1);

-- ================= CREATION OF THE TABLE pm_lang ===============

CREATE TABLE IF NOT EXISTS pm_lang(
    id int NOT NULL AUTO_INCREMENT,
    title varchar(20),
    locale varchar(20),
    main int DEFAULT 0,
    checked int DEFAULT 0,
    rank int DEFAULT 0,
    tag varchar(20),
    rtl int DEFAULT 0,
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

--
-- Content OF THE TABLE pm_lang
--

INSERT INTO pm_lang (id, title, locale, main, checked, rank, tag, rtl) VALUES
(1, 'Français', 'fr_FR', 0, 1, 2, 'fr', 0),
(2, 'English', 'en_GB', 1, 1, 1, 'en', 0),
(3, 'عربي', 'ar_MA', 0, 1, 3, 'ar', 1);

-- ============== CREATION OF THE TABLE pm_lang_file =============

CREATE TABLE IF NOT EXISTS pm_lang_file (
    id int NOT NULL AUTO_INCREMENT,
    id_item int NOT NULL,
    home int DEFAULT 0,
    checked int DEFAULT 1,
    rank int DEFAULT 0,
    file varchar(250),
    label varchar(250),
    type varchar(20),
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_lang_file ADD CONSTRAINT lang_file_fkey FOREIGN KEY (id_item) REFERENCES pm_lang(id) ON UPDATE NO ACTION ON DELETE CASCADE;

--
-- Content OF THE TABLE pm_lang_file
--

INSERT INTO pm_lang_file (id, id_item, home, checked, rank, file, label, type) VALUES
(1, 1, 0, 1, 2, 'fr.png', '', 'image'),
(2, 2, 0, 1, 1, 'gb.png', '', 'image'),
(3, 3, 0, 1, 3, 'ar.png', '', 'image');

-- ================= CREATION OF THE TABLE pm_page ===============

CREATE TABLE IF NOT EXISTS pm_page(
    id int NOT NULL AUTO_INCREMENT,
    lang int NOT NULL,
    name varchar(50),
    title varchar(250),
    subtitle varchar(250),
    title_tag varchar(250),
    alias varchar(100),
    descr longtext,
    robots varchar(20),
    keywords varchar(250),
    intro longtext,
    text longtext,
    text2 longtext,
    id_parent int,
    page_model varchar(50),
    article_model varchar(50),
    main int DEFAULT 1,
    footer int DEFAULT 0,
    home int DEFAULT 0,
    checked int DEFAULT 0,
    rank int DEFAULT 0,
    add_date int,
    edit_date int,
    comment int DEFAULT 0,
    rating int DEFAULT 0,
    system int DEFAULT 0,
    PRIMARY KEY(id, lang)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_page ADD CONSTRAINT page_lang_fkey FOREIGN KEY (lang) REFERENCES pm_lang(id) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Content OF THE TABLE pm_page
--

INSERT INTO pm_page (id, lang, name, title, subtitle, title_tag, alias, descr, robots, keywords, intro, text, text2, id_parent, page_model, article_model, main, footer, home, checked, rank, add_date, edit_date, comment, rating, system) VALUES
(1, 1, 'Accueil', 'Lorem ipsum dolor sit amet', 'Consectetur adipiscing elit', 'Accueil', '', '', 'index,follow', '', '', '', '', 0, 'home', '', 1, 0, 1, 1, 1, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(1, 2, 'Home', 'Pandao CMS', 'web software to create and manage your own website', 'Pandao CMS web software to create and manage your own website', '', '', 'index,follow', '', '', '<h3>Light weight</h3>\r\n\r\n<p><em>"The web should be fast", Google.</em> Only 10Mb and less than 450 files against 20Mb and a bit more than 1100 files for a famous CMS! <strong>Optimized page loading</strong> to be faster and more efficient.</p>\r\n\r\n<hr />\r\n<h3>Multilingual support</h3>\r\n\r\n<p><strong>Ready to be translated!</strong> Simply insert a new language into the admin panel and draft your articles, your pages and other texts in your website...</p>\r\n\r\n<hr />\r\n<h3>Easy to use</h3>\r\n\r\n<p>Studied to be personalized by novices and used by <strong>people without skills in computing</strong>. All the features are simple and intuitive.</p>\r\n', '', 0, 'home', '', 1, 0, 1, 1, 1, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(1, 3, 'ترحيب', 'هو سقطت الساحلية ذات, أن.', 'غير بمعارضة وهولندا، الإقتصادية قد, فقد الفرنسي المعاهدات قد من.', 'ترحيب', '', '', 'index,follow', '', '', '', '', 0, 'home', '', 1, 0, 1, 1, 1, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(2, 1, 'Contact', 'Contact', '', 'Contact', 'contact', '', 'index,follow', '', '', '', '', 0, 'contact', '', 1, 1, 0, 1, 4, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(2, 2, 'Contact', 'Contact', '', 'Contact', 'contact', '', 'index,follow', '', '', '', '', 0, 'contact', '', 1, 1, 0, 1, 4, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(2, 3, 'جهة الاتصال', 'جهة الاتصال', '', 'جهة الاتصال', 'contact', '', 'index,follow', '', '', '', '', 0, 'contact', '', 1, 1, 0, 1, 4, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(3, 1, 'Mentions légales', 'Mentions légales', '', 'Mentions légales', 'mentions-legales', '', 'index,follow', '', '', '', '', 0, 'page', '', 0, 1, 0, 1, 5, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(3, 2, 'Legal notices', 'Legal notices', '', 'Legal notices', 'legal-notices', '', 'index,follow', '', '', '', '', 0, 'page', '', 0, 1, 0, 1, 5, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(3, 3, 'يذكر القانونية', 'يذكر القانونية', '', 'يذكر القانونية', 'legal-notices', '', 'index,follow', '', '', '', '', 0, 'page', '', 0, 1, 0, 1, 5, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(4, 1, 'Plan du site', 'Plan du site', '', 'Plan du site', 'plan-site', '', 'index,follow', '', '', '', '', 0, 'sitemap', '', 0, 1, 0, 1, 6, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(4, 2, 'Sitemap', 'Sitemap', '', 'Sitemap', 'sitemap', '', 'index,follow', '', '', '', '', 0, 'sitemap', '', 0, 1, 0, 1, 6, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(4, 3, 'خريطة الموقع', 'خريطة الموقع', '', 'خريطة الموقع', 'sitemap', '', 'index,follow', '', '', '', '', 0, 'sitemap', '', 0, 1, 0, 1, 6, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(5, 1, 'Ma première page', 'Ma première page', '', 'Ma première page', 'my-first-page', '', 'index,follow', '', '', '', '', 0, 'page', 'article', 1, 0, 0, 1, 2, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(5, 2, 'My first page', 'My first page', '', 'My first page', 'my-first-page', '', 'index,follow', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque fringilla vel est at rhoncus. Cras porttitor ligula vel magna vehicula accumsan. Mauris eget elit et sem commodo interdum. Aenean dolor sem, tincidunt ac neque tempus, hendrerit blandit lacus. Vivamus placerat nulla in mi tristique, fringilla fermentum nisl vehicula. Nullam quis eros non magna tincidunt interdum ac eu eros. Morbi malesuada pulvinar ultrices. Etiam bibendum efficitur risus, sit amet venenatis urna ullamcorper non. Proin fermentum malesuada tortor, vitae mattis sem scelerisque in. Curabitur rutrum leo at mi efficitur suscipit. Vivamus tristique lorem eros, sit amet malesuada augue sodales sed.</p>\r\n', '<p>Etiam bibendum efficitur risus, sit amet venenatis urna ullamcorper non. Proin fermentum malesuada tortor, vitae mattis sem scelerisque in. Curabitur rutrum leo at mi efficitur.</p>\r\n', 0, 'page', 'article', 1, 0, 0, 1, 2, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(5, 3, 'صفحتي الأولى', 'صفحتي الأولى', '', 'صفحتي الأولى', 'my-first-page', '', 'index,follow', '', '', '', '', 0, 'page', 'article', 1, 0, 0, 1, 2, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(6, 1, 'Recherche', 'Recherche', '', 'Recherche', 'search', '', 'noindex,nofollow', '', '', '', '', 0, 'search', '', 0, 0, 0, 1, 7, INSTALL_DATE, INSTALL_DATE, 0, 0, 1),
(6, 2, 'Search', 'Search', '', 'Search', 'search', '', 'noindex,nofollow', '', '', '', '', 0, 'search', '', 0, 0, 0, 1, 7, INSTALL_DATE, INSTALL_DATE, 0, 0, 1),
(6, 3, 'بحث', 'بحث', '', 'بحث', 'search', '', 'noindex,nofollow', '', '', '', '', 0, 'search', '', 0, 0, 0, 1, 7, INSTALL_DATE, INSTALL_DATE, 0, 0, 1),
(7, 1, 'Galerie', 'Galerie', '', 'Galerie', 'galerie', '', 'index,follow', '', '', '', '', 0, 'page', 'gallery', 1, 0, 0, 1, 3, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(7, 2, 'Gallery', 'Gallery', '', 'Gallery', 'gallery', '', 'index,follow', '', '', '', '', 0, 'page', 'gallery', 1, 0, 0, 1, 3, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(7, 3, 'صور معرض', 'صور معرض', '', 'صور معرض', 'gallery', '', 'index,follow', '', '', '', '', 0, 'page', 'gallery', 1, 0, 0, 1, 3, INSTALL_DATE, INSTALL_DATE, 0, 0, 0),
(8, 1, '404', 'Erreur 404 : Page introuvable !', '', '404 Page introuvable', '404', '', 'noindex,nofollow', '', '', '<p>L''URL demandée n''a pas été trouvée sur ce serveur.<br />\r\nLa page que vous voulez afficher n''existe pas, ou est temporairement indisponible.</p>\r\n\r\n<p>Merci d''essayer les actions suivantes :</p>\r\n\r\n<ul>\r\n	<li>Assurez-vous que l''URL dans la barre d''adresse de votre navigateur est correctement orthographiée et formatée.</li>\r\n	<li>Si vous avez atteint cette page en cliquant sur un lien ou si vous pensez que cela concerne une erreur du serveur, contactez l''administrateur pour l''alerter.</li>\r\n</ul>\r\n', '', 0, '404', '', 0, 0, 0, 1, 8, INSTALL_DATE, INSTALL_DATE, 0, 0, 1),
(8, 2, '404', '404 Error: Page not found!', '', '404 Not Found', '404', '', 'noindex,nofollow', '', '', '<p>The wanted URL was not found on this server.<br />\r\nThe page you wish to display does not exist, or is temporarily unavailable.</p>\r\n\r\n<p>Thank you for trying the following actions :</p>\r\n\r\n<ul>\r\n	<li>Be sure the URL in the address bar of your browser is correctly spelt and formated.</li>\r\n	<li>If you reached this page by clicking a link or if you think that it is about an error of the server, contact the administrator to alert him.</li>\r\n</ul>\r\n', '', 0, '404', '', 0, 0, 0, 1, 8, INSTALL_DATE, INSTALL_DATE, 0, 0, 1),
(8, 3, '404', '404 Error: Page not found!', '', '404 Not Found', '404', '', 'noindex,nofollow', '', '', '', '', 0, '404', '', 0, 0, 0, 1, 8, INSTALL_DATE, INSTALL_DATE, 0, 0, 1);

-- ============== CREATION OF THE TABLE pm_page_file =============

CREATE TABLE IF NOT EXISTS pm_page_file (
    id int NOT NULL AUTO_INCREMENT,
    lang int NOT NULL,
    id_item int NOT NULL,
    home int DEFAULT 0,
    checked int DEFAULT 1,
    rank int DEFAULT 0,
    file varchar(250),
    label varchar(250),
    type varchar(20),
    PRIMARY KEY(id,lang)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_page_file ADD CONSTRAINT page_file_fkey FOREIGN KEY (id_item, lang) REFERENCES pm_page(id, lang) ON UPDATE NO ACTION ON DELETE CASCADE;
ALTER TABLE pm_page_file ADD CONSTRAINT page_file_lang_fkey FOREIGN KEY (lang) REFERENCES pm_lang(id) ON DELETE CASCADE ON UPDATE NO ACTION;

-- ================ CREATION OF THE TABLE pm_media ===============

CREATE TABLE IF NOT EXISTS pm_media(
    id int NOT NULL AUTO_INCREMENT,
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

-- ============== CREATION OF THE TABLE pm_media_file ============

CREATE TABLE IF NOT EXISTS pm_media_file (
    id int NOT NULL AUTO_INCREMENT,
    id_item int NOT NULL,
    home int DEFAULT 0,
    checked int DEFAULT 1,
    rank int DEFAULT 0,
    file varchar(250),
    label varchar(250),
    type varchar(20),
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_media_file ADD CONSTRAINT media_file_fkey FOREIGN KEY (id_item) REFERENCES pm_media(id) ON UPDATE NO ACTION ON DELETE CASCADE;

-- ================ CREATION OF THE TABLE pm_text ================

CREATE TABLE IF NOT EXISTS pm_text(
    id int NOT NULL AUTO_INCREMENT,
    lang int NOT NULL,
    name varchar(50),
    value varchar(250),
    PRIMARY KEY(id, lang)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_text ADD CONSTRAINT text_lang_fkey FOREIGN KEY (lang) REFERENCES pm_lang(id) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Content OF THE TABLE pm_text
--

INSERT INTO pm_text (id, lang, name, value) VALUES
(1, 1, 'CREATION', 'Création'),
(1, 2, 'CREATION', 'Creation'),
(1, 3, 'CREATION', 'إنشاء'),
(2, 1, 'MESSAGE', 'Message'),
(2, 2, 'MESSAGE', 'Message'),
(2, 3, 'MESSAGE', 'رسالة'),
(3, 1, 'EMAIL', 'E-mail'),
(3, 2, 'EMAIL', 'E-mail'),
(3, 3, 'EMAIL', 'بَرِيدٌ إلِكْترونيّ'),
(4, 1, 'PHONE', 'Tél.'),
(4, 2, 'PHONE', 'Phone'),
(4, 3, 'PHONE', 'رقم هاتف'),
(5, 1, 'FAX', 'Fax'),
(5, 2, 'FAX', 'Fax'),
(5, 3, 'FAX', 'فاكس'),
(6, 1, 'COMPANY', 'Société'),
(6, 2, 'COMPANY', 'Company'),
(6, 3, 'COMPANY', 'مشروع'),
(7, 1, 'COPY_CODE', 'Recopiez le code'),
(7, 2, 'COPY_CODE', 'Copy the code'),
(7, 3, 'COPY_CODE', 'رمز الأمان'),
(8, 1, 'SUBJECT', 'Sujet'),
(8, 2, 'SUBJECT', 'Subject'),
(8, 3, 'SUBJECT', 'موضوع'),
(9, 1, 'REQUIRED_FIELD', 'Champ requis'),
(9, 2, 'REQUIRED_FIELD', 'Required field'),
(9, 3, 'REQUIRED_FIELD', 'الحقل المطلوب'),
(10, 1, 'INVALID_CAPTCHA_CODE', 'Le code de sécurité saisi est incorrect'),
(10, 2, 'INVALID_CAPTCHA_CODE', 'Invalid security code'),
(10, 3, 'INVALID_CAPTCHA_CODE', 'رمز الحماية أدخلته غير صحيح'),
(11, 1, 'INVALID_EMAIL', 'Adresse e-mail invalide'),
(11, 2, 'INVALID_EMAIL', 'Invalid email address'),
(11, 3, 'INVALID_EMAIL', 'بريد إلكتروني خاطئ'),
(12, 1, 'FIRSTNAME', 'Prénom'),
(12, 2, 'FIRSTNAME', 'Firstname'),
(12, 3, 'FIRSTNAME', 'الاسم الأول'),
(13, 1, 'LASTNAME', 'Nom'),
(13, 2, 'LASTNAME', 'Lastname'),
(13, 3, 'LASTNAME', 'اسم العائلة'),
(14, 1, 'ADDRESS', 'Adresse'),
(14, 2, 'ADDRESS', 'Address'),
(14, 3, 'ADDRESS', 'عنوان الشارع'),
(15, 1, 'POSTCODE', 'Code postal'),
(15, 2, 'POSTCODE', 'Post code'),
(15, 3, 'POSTCODE', 'الرمز البريدي'),
(16, 1, 'CITY', 'Ville'),
(16, 2, 'CITY', 'City'),
(16, 3, 'CITY', 'مدينة'),
(17, 1, 'MOBILE', 'Portable'),
(17, 2, 'MOBILE', 'Mobile'),
(17, 3, 'MOBILE', 'هاتف'),
(18, 1, 'ADD', 'Ajouter'),
(18, 2, 'ADD', 'Add'),
(18, 3, 'ADD', 'إضافة على'),
(19, 1, 'EDIT', 'Modifier'),
(19, 2, 'EDIT', 'Edit'),
(19, 3, 'EDIT', 'تغيير'),
(20, 1, 'INVALID_INPUT', 'Saisie invalide'),
(20, 2, 'INVALID_INPUT', 'Invalid input'),
(20, 3, 'INVALID_INPUT', 'إدخال غير صالح'),
(21, 1, 'MAIL_DELIVERY_FAILURE', 'Echec lors de l''envoi du message.'),
(21, 2, 'MAIL_DELIVERY_FAILURE', 'A failure occurred during the delivery of this message.'),
(21, 3, 'MAIL_DELIVERY_FAILURE', 'حدث فشل أثناء تسليم هذه الرسالة.'),
(22, 1, 'MAIL_DELIVERY_SUCCESS', 'Merci de votre intérêt, votre message a bien été envoyé.\nNous vous contacterons dans les plus brefs délais.'),
(22, 2, 'MAIL_DELIVERY_SUCCESS', 'Thank you for your interest, your message has been sent.\nWe will contact you as soon as possible.'),
(22, 3, 'MAIL_DELIVERY_SUCCESS', 'خزان لاهتمامك ، تم إرسال رسالتك . سوف نتصل بك في أقرب وقت ممكن .'),
(23, 1, 'SEND', 'Envoyer'),
(23, 2, 'SEND', 'Send'),
(23, 3, 'SEND', 'ارسل انت'),
(24, 1, 'FORM_ERRORS', 'Le formulaire comporte des erreurs.'),
(24, 2, 'FORM_ERRORS', 'The following form contains some errors.'),
(24, 3, 'FORM_ERRORS', 'النموذج التالي يحتوي على بعض الأخطاء.'),
(25, 1, 'FROM_DATE', 'Du'),
(25, 2, 'FROM_DATE', 'From'),
(25, 3, 'FROM_DATE', 'من'),
(26, 1, 'TO_DATE', 'au'),
(26, 2, 'TO_DATE', 'till'),
(26, 3, 'TO_DATE', 'حتى'),
(27, 1, 'FROM', 'De'),
(27, 2, 'FROM', 'From'),
(27, 3, 'FROM', 'من'),
(28, 1, 'TO', 'à'),
(28, 2, 'TO', 'to'),
(28, 3, 'TO', 'إلى'),
(29, 1, 'BOOK', 'Réserver'),
(29, 2, 'BOOK', 'Book'),
(29, 3, 'BOOK', 'للحجز'),
(30, 1, 'READMORE', 'Lire la suite'),
(30, 2, 'READMORE', 'Read more'),
(30, 3, 'READMORE', 'اقرأ المزيد'),
(31, 1, 'BACK', 'Retour'),
(31, 2, 'BACK', 'Back'),
(31, 3, 'BACK', 'عودة'),
(32, 1, 'DISCOVER', 'Découvrir'),
(32, 2, 'DISCOVER', 'Discover'),
(32, 3, 'DISCOVER', 'اكتشف'),
(33, 1, 'ALL', 'Tous'),
(33, 2, 'ALL', 'All'),
(33, 3, 'ALL', 'كل'),
(34, 1, 'ALL_RIGHTS_RESERVED', 'Tous droits réservés'),
(34, 2, 'ALL_RIGHTS_RESERVED', 'All rights reserved'),
(34, 3, 'ALL_RIGHTS_RESERVED', 'جميع الحقوق محفوظه'),
(35, 1, 'FORGOTTEN_PASSWORD', 'Mot de passe oublié ?'),
(35, 2, 'FORGOTTEN_PASSWORD', 'Forgotten password?'),
(35, 3, 'FORGOTTEN_PASSWORD', 'هل نسيت كلمة المرور؟'),
(36, 1, 'LOG_IN', 'Connexion'),
(36, 2, 'LOG_IN', 'Log in'),
(36, 3, 'LOG_IN', 'تسجيل الدخول'),
(37, 1, 'SIGN_UP', 'Inscription'),
(37, 2, 'SIGN_UP', 'Sign up'),
(37, 3, 'SIGN_UP', 'تسجيل'),
(38, 1, 'LOG_OUT', 'Déconnexion'),
(38, 2, 'LOG_OUT', 'Log out'),
(38, 3, 'LOG_OUT', 'تسجيل الخروج'),
(39, 1, 'SEARCH', 'Rechercher'),
(39, 2, 'SEARCH', 'Search'),
(39, 3, 'SEARCH', 'ابحث عن'),
(40, 1, 'RESET_PASS_SUCCESS', 'Votre nouveau mot de passe vous a été envoyé sur votre adresse e-mail.'),
(40, 2, 'RESET_PASS_SUCCESS', 'Your new password was sent to you on your e-mail.'),
(40, 3, 'RESET_PASS_SUCCESS', 'تم إرسال كلمة المرور الجديدة إلى عنوان البريد الإلكتروني الخاص بك'),
(41, 1, 'PASS_TOO_SHORT', 'Le mot de passe doit contenir 6 caractères au minimum'),
(41, 2, 'PASS_TOO_SHORT', 'The password must contain 6 characters at least'),
(41, 3, 'PASS_TOO_SHORT', 'يجب أن يحتوي على كلمة المرور ستة أحرف على الأقل'),
(42, 1, 'PASS_DONT_MATCH', 'Les mots de passe doivent correspondre'),
(42, 2, 'PASS_DONT_MATCH', 'The passwords don''t match'),
(42, 3, 'PASS_DONT_MATCH', 'يجب أن تتطابق كلمات المرور'),
(43, 1, 'ACCOUNT_EXISTS', 'Un compte existe déjà avec cette adresse e-mail'),
(43, 2, 'ACCOUNT_EXISTS', 'An account already exists with this e-mail'),
(43, 3, 'ACCOUNT_EXISTS', 'حساب موجود بالفعل مع هذا عنوان البريد الإلكتروني'),
(44, 1, 'ACCOUNT_CREATED', 'Votre compte a bien été créé.'),
(44, 2, 'ACCOUNT_CREATED', 'Your account was well created.'),
(44, 3, 'ACCOUNT_CREATED', 'لقد تم إنشاء حسابك'),
(45, 1, 'INCORRECT_LOGIN', 'Les informations de connexion sont incorrectes.'),
(45, 2, 'INCORRECT_LOGIN', 'Incorrect login information.'),
(45, 3, 'INCORRECT_LOGIN', 'معلومات تسجيل الدخول غير صحيحة.'),
(46, 1, 'I_SIGN_UP', 'Je m''inscris'),
(46, 2, 'I_SIGN_UP', 'I sign up'),
(46, 3, 'I_SIGN_UP', 'يمكنني الاشتراك'),
(47, 1, 'ALREADY_HAVE_ACCOUNT', 'J''ai déjà un compte'),
(47, 2, 'ALREADY_HAVE_ACCOUNT', 'I already have an account'),
(47, 3, 'ALREADY_HAVE_ACCOUNT', 'لدي بالفعل حساب'),
(48, 1, 'MY_ACCOUNT', 'Mon compte'),
(48, 2, 'MY_ACCOUNT', 'My account'),
(48, 3, 'MY_ACCOUNT', 'حسابي'),
(49, 1, 'COMMENTS', 'Commentaires'),
(49, 2, 'COMMENTS', 'Comments'),
(49, 3, 'COMMENTS', 'تعليقات'),
(50, 1, 'LET_US_KNOW', 'Faîtes-nous savoir ce que vous pensez'),
(50, 2, 'LET_US_KNOW', 'Let us know what you think'),
(50, 3, 'LET_US_KNOW', 'ماذا عن رايك؟'),
(51, 1, 'COMMENT_SUCCESS', 'Merci de votre intérêt, votre commentaire va être soumis à validation.'),
(51, 2, 'COMMENT_SUCCESS', 'Thank you for your interest, your comment will be checked.'),
(51, 3, 'COMMENT_SUCCESS', 'شكرا ل اهتمامك، و سيتم التحقق من صحة للتعليق.'),
(52, 1, 'NO_SEARCH_RESULT', 'Aucun résultat. Vérifiez l''orthographe des termes de recherche (> 3 caractères) ou essayez d''autres mots.'),
(52, 2, 'NO_SEARCH_RESULT', 'No result. Check the spelling terms of search (> 3 characters) or try other words.'),
(52, 3, 'NO_SEARCH_RESULT', 'لا نتيجة. التدقيق الإملائي للكلمات (أكثر من ثلاثة أحرف ) أو محاولة بعبارة أخرى .'),
(53, 1, 'SEARCH_EXCEEDED', 'Nombre de recherches dépassé.'),
(53, 2, 'SEARCH_EXCEEDED', 'Number of researches exceeded.'),
(53, 3, 'SEARCH_EXCEEDED', 'عدد من الأبحاث السابقة .'),
(54, 1, 'SECONDS', 'secondes'),
(54, 2, 'SECONDS', 'seconds'),
(54, 3, 'SECONDS', 'ثواني'),
(55, 1, 'FOR_A_TOTAL_OF', 'sur un total de'),
(55, 2, 'FOR_A_TOTAL_OF', 'for a total of'),
(55, 3, 'FOR_A_TOTAL_OF', 'من الكل'),
(56, 1, 'COMMENT', 'Commentaire'),
(56, 2, 'COMMENT', 'Comment'),
(56, 3, 'COMMENT', 'تعقيب'),
(57, 1, 'VIEW', 'Visionner'),
(57, 2, 'VIEW', 'View'),
(57, 3, 'VIEW', 'ل عرض'),
(58, 1, 'RECENT_ARTICLES', 'Articles récents'),
(58, 2, 'RECENT_ARTICLES', 'Recent articles'),
(58, 3, 'RECENT_ARTICLES', 'المقالات الأخيرة'),
(59, 1, 'RSS_FEED', 'Flux RSS'),
(59, 2, 'RSS_FEED', 'RSS feed'),
(59, 3, 'RSS_FEED', 'تغذية RSS'),
(60, 1, 'RATINGS', 'Note(s)'),
(60, 2, 'RATINGS', 'Rating(s)'),
(60, 3, 'RATINGS', 'Rating(s)');

-- =============== CREATION OF THE TABLE pm_widget ===============

CREATE TABLE IF NOT EXISTS pm_widget(
    id int NOT NULL AUTO_INCREMENT,
    lang int NOT NULL,
    title varchar(250),
    showtitle int,
    pos varchar(20),
    allpages int,
    pages varchar(250),
    type varchar(20),
    class varchar(250),
    content longtext,
    checked int DEFAULT 0,
    rank int DEFAULT 0,
    PRIMARY KEY(id, lang)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_widget ADD CONSTRAINT widget_lang_fkey FOREIGN KEY (lang) REFERENCES pm_lang(id) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Content OF THE TABLE pm_widget
--

INSERT INTO pm_widget (id, lang, title, showtitle, pos, allpages, pages, type, class, content, checked, rank) VALUES
(1, 1, 'Qui sommes-nous ?', 1, 'footer', 1, '', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum eget auctor ipsum. Mauris pharetra neque a mauris commodo, at aliquam leo malesuada. Maecenas eget elit eu ligula rhoncus dapibus at non erat. In sed velit eget eros gravida consectetur varius imperdiet lectus.</p>\r\n', 1, 1),
(1, 2, 'About us', 1, 'footer', 1, '', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum eget auctor ipsum. Mauris pharetra neque a mauris commodo, at aliquam leo malesuada. Maecenas eget elit eu ligula rhoncus dapibus at non erat. In sed velit eget eros gravida consectetur varius imperdiet lectus.</p>\r\n', 1, 1),
(1, 3, 'عنا', 1, 'footer', 1, '', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum eget auctor ipsum. Mauris pharetra neque a mauris commodo, at aliquam leo malesuada. Maecenas eget elit eu ligula rhoncus dapibus at non erat. In sed velit eget eros gravida consectetur varius imperdiet lectus.</p>\r\n', 1, 1),
(3, 1, 'Derniers articles', 1, 'footer', 1, '', 'latest_articles', '', '', 1, 2),
(3, 2, 'Latest articles', 1, 'footer', 1, '', 'latest_articles', '', '', 1, 2),
(3, 3, 'المقالات الأخيرة', 1, 'footer', 1, '', 'latest_articles', '', '', 1, 2),
(4, 1, 'Contactez-nous', 0, 'footer', 1, '', 'contact_informations', '', '', 1, 3),
(4, 2, 'Contact us', 0, 'footer', 1, '', 'contact_informations', '', '', 1, 3),
(4, 3, 'اتصل بنا', 0, 'footer', 1, '', 'contact_informations', '', '', 1, 3);

-- ================ CREATION OF THE TABLE pm_article =============

CREATE TABLE IF NOT EXISTS pm_article(
    id int NOT NULL AUTO_INCREMENT,
    lang int NOT NULL,
    title varchar(250),
    subtitle varchar(250),
    alias varchar(100),
    text longtext,
    url varchar(250),
    tags varchar(250),
    id_page int,
    id_user int,
    home int DEFAULT 0,
    checked int DEFAULT 0,
    rank int DEFAULT 0,
    add_date int,
    edit_date int,
    publish_date int,
    unpublish_date int,
    comment int DEFAULT 0,
    rating int DEFAULT 0,
    PRIMARY KEY(id, lang)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_article ADD CONSTRAINT article_lang_fkey FOREIGN KEY (lang) REFERENCES pm_lang(id) ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE pm_article ADD CONSTRAINT article_page_fkey FOREIGN KEY (id_page, lang) REFERENCES pm_page(id, lang) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Content OF THE TABLE pm_article
--

INSERT INTO pm_article (id, lang, title, subtitle, alias, text, url, tags, id_page, id_user, home, checked, rank, add_date, edit_date, publish_date, unpublish_date, comment, rating) VALUES
(1, 1, 'Mon premier article', '', 'mon-premier-article', '', '', '1,2', 5, 1, 1, 1, 1, INSTALL_DATE, INSTALL_DATE, null, null, 1, 0),
(1, 2, 'My first article', '', 'my-first-article', '<p>Lorem ipsum dolor sit amet consectetur adipiscing elit. Nullam molestie, nunc eu consequat varius, nisi metus iaculis nulla, nec ornare odio leo quis eros. Donec gravida eget velit eget pulvinar. Phasellus eget est quis est faucibus condimentum. Morbi tellus turpis, posuere vel tincidunt non, varius ac ante. Suspendisse in sem neque. Donec et faucibus justo. Nulla vitae nisl lacus. Fusce tincidunt quam nec vestibulum vestibulum. Vivamus vulputate, nunc non ullamcorper mattis, nunc orci imperdiet nulla, at laoreet ipsum nisl non leo. Aenean dapibus aliquet sem, ut lacinia magna mattis in.</p>\r\n\r\n<h3>Mauris et euismod enim, eget elementum orci</h3>\r\n\r\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Curabitur tempor arcu eu sapien ullamcorper sodales. Aenean eu massa in ante commodo scelerisque vitae sed sapien. Aenean eu dictum arcu. Mauris ultricies dolor eu molestie egestas.<br />\r\nProin feugiat, nunc at pellentesque fringilla, ex purus efficitur dolor, ac pretium odio lacus id leo. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse eu ipsum viverra dolor tempus vehicula eu eu risus. Praesent rutrum dapibus odio, nec accumsan justo fermentum in. Ut quis neque a ante facilisis bibendum.</p>\r\n', '', '1,2', 5, 1, 1, 1, 1, INSTALL_DATE, INSTALL_DATE, null, null, 1, 0),
(1, 3, 'My first article', '', 'my-first-article', '<p>Lorem ipsum dolor sit amet consectetur adipiscing elit. Nullam molestie, nunc eu consequat varius, nisi metus iaculis nulla, nec ornare odio leo quis eros. Donec gravida eget velit eget pulvinar. Phasellus eget est quis est faucibus condimentum. Morbi tellus turpis, posuere vel tincidunt non, varius ac ante. Suspendisse in sem neque. Donec et faucibus justo. Nulla vitae nisl lacus. Fusce tincidunt quam nec vestibulum vestibulum. Vivamus vulputate, nunc non ullamcorper mattis, nunc orci imperdiet nulla, at laoreet ipsum nisl non leo. Aenean dapibus aliquet sem, ut lacinia magna mattis in.</p>\r\n\r\n<h3>Mauris et euismod enim, eget elementum orci</h3>\r\n\r\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Curabitur tempor arcu eu sapien ullamcorper sodales. Aenean eu massa in ante commodo scelerisque vitae sed sapien. Aenean eu dictum arcu. Mauris ultricies dolor eu molestie egestas.<br />\r\nProin feugiat, nunc at pellentesque fringilla, ex purus efficitur dolor, ac pretium odio lacus id leo. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse eu ipsum viverra dolor tempus vehicula eu eu risus. Praesent rutrum dapibus odio, nec accumsan justo fermentum in. Ut quis neque a ante facilisis bibendum.</p>\r\n', '', '1,2', 5, 1, 1, 1, 1, INSTALL_DATE, INSTALL_DATE, null, null, 1, 0),
(2, 1, 'Panel de gestion intuitif', '', 'panel-de-gestion-intuitif', '', '', '1', 5, 1, 1, 1, 2, INSTALL_DATE, INSTALL_DATE, null, null, 1, 0),
(2, 2, 'Intuitive admin panel', '', 'intuitive-admin-panel', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam molestie, nunc eu consequat varius, nisi metus iaculis nulla, nec ornare odio leo quis eros. Donec gravida eget velit eget pulvinar. Phasellus eget est quis est faucibus condimentum. Morbi tellus turpis, posuere vel tincidunt non, varius ac ante. Suspendisse in sem neque. Donec et faucibus justo. Nulla vitae nisl lacus. Fusce tincidunt quam nec vestibulum vestibulum. Vivamus vulputate, nunc non ullamcorper mattis, nunc orci imperdiet nulla, at laoreet ipsum nisl non leo. Aenean dapibus aliquet sem, ut lacinia magna mattis in.</p>\r\n\r\n<p>Mauris et euismod enim, eget elementum orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Curabitur tempor arcu eu sapien ullamcorper sodales. Aenean eu massa in ante commodo scelerisque vitae sed sapien. Aenean eu dictum arcu. Mauris ultricies dolor eu molestie egestas. Proin feugiat, nunc at pellentesque fringilla, ex purus efficitur dolor, ac pretium odio lacus id leo. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse eu ipsum viverra dolor tempus vehicula eu eu risus. Praesent rutrum dapibus odio, nec accumsan justo fermentum in. Ut quis neque a ante facilisis bibendum.</p>\r\n', '', '1', 5, 1, 1, 1, 2, INSTALL_DATE, INSTALL_DATE, null, null, 1, 0),
(2, 3, 'Intuitive admin panel', '', 'intuitive-admin-panel', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam molestie, nunc eu consequat varius, nisi metus iaculis nulla, nec ornare odio leo quis eros. Donec gravida eget velit eget pulvinar. Phasellus eget est quis est faucibus condimentum. Morbi tellus turpis, posuere vel tincidunt non, varius ac ante. Suspendisse in sem neque. Donec et faucibus justo. Nulla vitae nisl lacus. Fusce tincidunt quam nec vestibulum vestibulum. Vivamus vulputate, nunc non ullamcorper mattis, nunc orci imperdiet nulla, at laoreet ipsum nisl non leo. Aenean dapibus aliquet sem, ut lacinia magna mattis in.</p>\r\n\r\n<p>Mauris et euismod enim, eget elementum orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Curabitur tempor arcu eu sapien ullamcorper sodales. Aenean eu massa in ante commodo scelerisque vitae sed sapien. Aenean eu dictum arcu. Mauris ultricies dolor eu molestie egestas. Proin feugiat, nunc at pellentesque fringilla, ex purus efficitur dolor, ac pretium odio lacus id leo. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse eu ipsum viverra dolor tempus vehicula eu eu risus. Praesent rutrum dapibus odio, nec accumsan justo fermentum in. Ut quis neque a ante facilisis bibendum.</p>\r\n', '', '1', 5, 1, 1, 1, 2, INSTALL_DATE, INSTALL_DATE, null, null, 1, 0),
(3, 1, 'Fully responsive', '', 'fully-responsive', '', '', '2', 5, 1, 1, 1, 3, INSTALL_DATE, INSTALL_DATE, null, null, 1, 0),
(3, 2, 'Fully responsive', '', 'fully-responsive', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam molestie, nunc eu consequat varius, nisi metus iaculis nulla, nec ornare odio leo quis eros. Donec gravida eget velit eget pulvinar. Phasellus eget est quis est faucibus condimentum. Morbi tellus turpis, posuere vel tincidunt non, varius ac ante. Suspendisse in sem neque. Donec et faucibus justo. Nulla vitae nisl lacus. Fusce tincidunt quam nec vestibulum vestibulum. Vivamus vulputate, nunc non ullamcorper mattis, nunc orci imperdiet nulla, at laoreet ipsum nisl non leo. Aenean dapibus aliquet sem, ut lacinia magna mattis in.</p>\r\n\r\n<p>Mauris et euismod enim, eget elementum orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Curabitur tempor arcu eu sapien ullamcorper sodales. Aenean eu massa in ante commodo scelerisque vitae sed sapien. Aenean eu dictum arcu. Mauris ultricies dolor eu molestie egestas. Proin feugiat, nunc at pellentesque fringilla, ex purus efficitur dolor, ac pretium odio lacus id leo. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse eu ipsum viverra dolor tempus vehicula eu eu risus. Praesent rutrum dapibus odio, nec accumsan justo fermentum in. Ut quis neque a ante facilisis bibendum.</p>\r\n', '', '2', 5, 1, 1, 1, 3, INSTALL_DATE, INSTALL_DATE, null, null, 1, 0),
(3, 3, 'Fully responsive', '', 'fully-responsive', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam molestie, nunc eu consequat varius, nisi metus iaculis nulla, nec ornare odio leo quis eros. Donec gravida eget velit eget pulvinar. Phasellus eget est quis est faucibus condimentum. Morbi tellus turpis, posuere vel tincidunt non, varius ac ante. Suspendisse in sem neque. Donec et faucibus justo. Nulla vitae nisl lacus. Fusce tincidunt quam nec vestibulum vestibulum. Vivamus vulputate, nunc non ullamcorper mattis, nunc orci imperdiet nulla, at laoreet ipsum nisl non leo. Aenean dapibus aliquet sem, ut lacinia magna mattis in.</p>\r\n\r\n<p>Mauris et euismod enim, eget elementum orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Curabitur tempor arcu eu sapien ullamcorper sodales. Aenean eu massa in ante commodo scelerisque vitae sed sapien. Aenean eu dictum arcu. Mauris ultricies dolor eu molestie egestas. Proin feugiat, nunc at pellentesque fringilla, ex purus efficitur dolor, ac pretium odio lacus id leo. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse eu ipsum viverra dolor tempus vehicula eu eu risus. Praesent rutrum dapibus odio, nec accumsan justo fermentum in. Ut quis neque a ante facilisis bibendum.</p>\r\n', '', '2', 5, 1, 1, 1, 3, INSTALL_DATE, INSTALL_DATE, null, null, 1, 0),
(4, 1, 'Première gallery', '', 'premiere-gallery', '', '', '' , 7, 1, 0, 1, 4, INSTALL_DATE, INSTALL_DATE, null, null, 0, 0),
(4, 2, 'First gallery', '', 'first-gallery', '', '', '' , 7, 1, 0, 1, 4, INSTALL_DATE, INSTALL_DATE, null, null, 0, 0),
(4, 3, 'First gallery', '', 'first-gallery', '', '', '' , 7, 1, 0, 1, 4, INSTALL_DATE, INSTALL_DATE, null, null, 0, 0);

-- ============= CREATION OF THE TABLE pm_article_file ===========

CREATE TABLE IF NOT EXISTS pm_article_file (
    id int NOT NULL AUTO_INCREMENT,
    lang int NOT NULL,
    id_item int NOT NULL,
    home int DEFAULT 0,
    checked int DEFAULT 1,
    rank int DEFAULT 0,
    file varchar(250),
    label varchar(250),
    type varchar(20),
    PRIMARY KEY(id, lang)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_article_file ADD CONSTRAINT article_file_fkey FOREIGN KEY (id_item, lang) REFERENCES pm_article(id, lang) ON UPDATE NO ACTION ON DELETE CASCADE;
ALTER TABLE pm_article_file ADD CONSTRAINT article_file_lang_fkey FOREIGN KEY (lang) REFERENCES pm_lang(id) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Content OF THE TABLE pm_article_file
--

INSERT INTO pm_article_file (id, lang, id_item, home, checked, rank, file, label, type) VALUES
(1, 1, 1, 0, 1, 1, 'sample.jpg', '', 'image'),
(1, 2, 1, 0, 1, 1, 'sample.jpg', '', 'image'),
(1, 3, 1, 0, 1, 1, 'sample.jpg', '', 'image'),
(2, 1, 2, 0, 1, 2, 'sample2.jpg', '', 'image'),
(2, 2, 2, 0, 1, 2, 'sample2.jpg', '', 'image'),
(2, 3, 2, 0, 1, 2, 'sample2.jpg', '', 'image'),
(3, 1, 3, 0, 1, 3, 'sample3.jpg', '', 'image'),
(3, 2, 3, 0, 1, 3, 'sample3.jpg', '', 'image'),
(3, 3, 3, 0, 1, 3, 'sample3.jpg', '', 'image'),
(4, 1, 4, 0, 1, 4, 'sample4.jpg', '', 'image'),
(4, 2, 4, 0, 1, 4, 'sample4.jpg', '', 'image'),
(4, 3, 4, 0, 1, 4, 'sample4.jpg', '', 'image');

-- ================ CREATION OF THE TABLE pm_comment =============

CREATE TABLE IF NOT EXISTS pm_comment (
    id int NOT NULL AUTO_INCREMENT,
    item_type varchar(30),
    id_item int,
    rating int,
    checked int DEFAULT 0,
    add_date int,
    edit_date int,
    name varchar(100),
    email varchar(100),
    msg longtext,
    ip varchar(50),
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

-- ================= CREATION OF THE TABLE pm_tag ================

CREATE TABLE IF NOT EXISTS pm_tag(
    id int NOT NULL AUTO_INCREMENT,
    lang int NOT NULL,
    value varchar(250),
    pages varchar(250),
    checked int DEFAULT 0,
    rank int DEFAULT 0,
    PRIMARY KEY(id, lang)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_tag ADD CONSTRAINT tag_lang_fkey FOREIGN KEY (lang) REFERENCES pm_lang(id) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Content OF THE TABLE pm_tag
--

INSERT INTO pm_tag (id, lang, value, pages, checked, rank) VALUES
(1, 1, 'Autre', '1,2,3,5,4,6', 1, 1),
(1, 2, 'Other', '1,2,3,5,4,6', 1, 1),
(2, 1, 'Projets web', '1,2,3,5,4,6', 1, 2),
(2, 2, 'Web projects', '1,2,3,5,4,6', 1, 2);

-- ================= CREATION OF THE TABLE pm_slide ==============

CREATE TABLE IF NOT EXISTS pm_slide(
    id int NOT NULL AUTO_INCREMENT,
    lang int NOT NULL,
    legend text,
    url varchar(250),
    id_page int,
    checked int DEFAULT 0,
    rank int DEFAULT 0,
    PRIMARY KEY(id, lang)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_slide ADD CONSTRAINT slide_lang_fkey FOREIGN KEY (lang) REFERENCES pm_lang(id) ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE pm_slide ADD CONSTRAINT slide_page_fkey FOREIGN KEY (id_page, lang) REFERENCES pm_page(id, lang) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Content OF THE TABLE pm_slide
--

INSERT INTO pm_slide (id, lang, legend, id_page, checked, rank) VALUES
(1, 1, '', 1, 1, 1),
(1, 2, '', 1, 1, 1),
(1, 3, '', 1, 1, 1),
(2, 1, '', 1, 1, 2),
(2, 2, '', 1, 1, 2),
(2, 3, '', 1, 1, 2);

-- ============== CREATION OF THE TABLE pm_slide_file ============

CREATE TABLE IF NOT EXISTS pm_slide_file (
    id int NOT NULL AUTO_INCREMENT,
    lang int NOT NULL,
    id_item int NOT NULL,
    home int DEFAULT 0,
    checked int DEFAULT 1,
    rank int DEFAULT 0,
    file varchar(250),
    label varchar(250),
    type varchar(20),
    PRIMARY KEY(id, lang)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

ALTER TABLE pm_slide_file ADD CONSTRAINT slide_file_fkey FOREIGN KEY (id_item, lang) REFERENCES pm_slide(id, lang) ON UPDATE NO ACTION ON DELETE CASCADE;
ALTER TABLE pm_slide_file ADD CONSTRAINT slide_file_lang_fkey FOREIGN KEY (lang) REFERENCES pm_lang(id) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Content OF THE TABLE pm_slide_file
--

INSERT INTO pm_slide_file (id, lang, id_item, home, checked, rank, file, label, type) VALUES
(1, 1, 1, 0, 1, 2, 'slide1.jpg', '', 'image'),
(1, 2, 1, 0, 1, 2, 'slide1.jpg', '', 'image'),
(1, 3, 1, 0, 1, 2, 'slide1.jpg', '', 'image'),
(2, 1, 2, 0, 1, 3, 'slide2.jpg', '', 'image'),
(2, 2, 2, 0, 1, 3, 'slide2.jpg', '', 'image'),
(2, 3, 2, 0, 1, 3, 'slide2.jpg', '', 'image');

-- =============== CREATION OF THE TABLE pm_location =============

CREATE TABLE IF NOT EXISTS pm_location(
    id int NOT NULL AUTO_INCREMENT,
    name varchar(100),
    address varchar(250),
    lat double,
    lng double,
    checked int DEFAULT 0,
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

--
-- Content OF THE TABLE pm_location
--

INSERT INTO pm_location (id, name, address, lat, lng, checked) VALUES
(1, 'Big Ben', 'London SW1A 0AA', '51.500729', '-0.124625', 1);

-- ================ CREATION OF THE TABLE pm_message =============

CREATE TABLE IF NOT EXISTS pm_message (
    id int NOT NULL AUTO_INCREMENT,
    add_date int,
    edit_date int,
    name varchar(100),
    email varchar(100),
    address longtext,
    phone varchar(100),
    subject varchar(250),
    msg longtext,
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

-- =============== CREATION OF THE TABLE pm_currency =============

CREATE TABLE IF NOT EXISTS pm_currency(
    id int NOT NULL AUTO_INCREMENT,
    code varchar(5),
    sign varchar(5),
    main int DEFAULT 0,
    rank int DEFAULT 0,
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

--
-- Content of the table pm_currency
--

INSERT INTO pm_currency (id, code, sign, main, rank) VALUES
(1, 'USD', '$', 1, 1),
(2, 'EUR', '€', 0, 2),
(3, 'GBP', '£', 0, 3),
(4, 'INR', '₹', 0, 4),
(5, 'AUD', 'A$', 0, 5),
(6, 'CAD', 'C$', 0, 6),
(7, 'CNY', '¥', 0, 7),
(8, 'TRY', '₺', 0, 8);

-- =============== CREATION OF THE TABLE pm_country ==============

CREATE TABLE IF NOT EXISTS pm_country(
    id int NOT NULL AUTO_INCREMENT,
    name varchar(100),
    code varchar(3),
    PRIMARY KEY(id)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

--
-- Content of the table pm_country
--

INSERT INTO pm_country VALUES
('', 'Afghanistan', 'AF'),
('', 'Åland', 'AX'),
('', 'Albania', 'AL'),
('', 'Algeria', 'DZ'),
('', 'American Samoa', 'AS'),
('', 'Andorra', 'AD'),
('', 'Angola', 'AO'),
('', 'Anguilla', 'AI'),
('', 'Antarctica', 'AQ'),
('', 'Antigua and Barbuda', 'AG'),
('', 'Argentina', 'AR'),
('', 'Armenia', 'AM'),
('', 'Aruba', 'AW'),
('', 'Australia', 'AU'),
('', 'Austria', 'AT'),
('', 'Azerbaijan', 'AZ'),
('', 'Bahamas', 'BS'),
('', 'Bahrain', 'BH'),
('', 'Bangladesh', 'BD'),
('', 'Barbados', 'BB'),
('', 'Belarus', 'BY'),
('', 'Belgium', 'BE'),
('', 'Belize', 'BZ'),
('', 'Benin', 'BJ'),
('', 'Bermuda', 'BM'),
('', 'Bhutan', 'BT'),
('', 'Bolivia', 'BO'),
('', 'Bonaire', 'BQ'),
('', 'Bosnia and Herzegovina', 'BA'),
('', 'Botswana', 'BW'),
('', 'Bouvet Island', 'BV'),
('', 'Brazil', 'BR'),
('', 'British Indian Ocean Territory', 'IO'),
('', 'British Virgin Islands', 'VG'),
('', 'Brunei', 'BN'),
('', 'Bulgaria', 'BG'),
('', 'Burkina Faso', 'BF'),
('', 'Burundi', 'BI'),
('', 'Cambodia', 'KH'),
('', 'Cameroon', 'CM'),
('', 'Canada', 'CA'),
('', 'Cape Verde', 'CV'),
('', 'Cayman Islands', 'KY'),
('', 'Central African Republic', 'CF'),
('', 'Chad', 'TD'),
('', 'Chile', 'CL'),
('', 'China', 'CN'),
('', 'Christmas Island', 'CX'),
('', 'Cocos [Keeling] Islands', 'CC'),
('', 'Colombia', 'CO'),
('', 'Comoros', 'KM'),
('', 'Cook Islands', 'CK'),
('', 'Costa Rica', 'CR'),
('', 'Croatia', 'HR'),
('', 'Cuba', 'CU'),
('', 'Curacao', 'CW'),
('', 'Cyprus', 'CY'),
('', 'Czech Republic', 'CZ'),
('', 'Democratic Republic of the Congo', 'CD'),
('', 'Denmark', 'DK'),
('', 'Djibouti', 'DJ'),
('', 'Dominica', 'DM'),
('', 'Dominican Republic', 'DO'),
('', 'East Timor', 'TL'),
('', 'Ecuador', 'EC'),
('', 'Egypt', 'EG'),
('', 'El Salvador', 'SV'),
('', 'Equatorial Guinea', 'GQ'),
('', 'Eritrea', 'ER'),
('', 'Estonia', 'EE'),
('', 'Ethiopia', 'ET'),
('', 'Falkland Islands', 'FK'),
('', 'Faroe Islands', 'FO'),
('', 'Fiji', 'FJ'),
('', 'Finland', 'FI'),
('', 'France', 'FR'),
('', 'French Guiana', 'GF'),
('', 'French Polynesia', 'PF'),
('', 'French Southern Territories', 'TF'),
('', 'Gabon', 'GA'),
('', 'Gambia', 'GM'),
('', 'Georgia', 'GE'),
('', 'Germany', 'DE'),
('', 'Ghana', 'GH'),
('', 'Gibraltar', 'GI'),
('', 'Greece', 'GR'),
('', 'Greenland', 'GL'),
('', 'Grenada', 'GD'),
('', 'Guadeloupe', 'GP'),
('', 'Guam', 'GU'),
('', 'Guatemala', 'GT'),
('', 'Guernsey', 'GG'),
('', 'Guinea', 'GN'),
('', 'Guinea-Bissau', 'GW'),
('', 'Guyana', 'GY'),
('', 'Haiti', 'HT'),
('', 'Heard Island and McDonald Islands', 'HM'),
('', 'Honduras', 'HN'),
('', 'Hong Kong', 'HK'),
('', 'Hungary', 'HU'),
('', 'Iceland', 'IS'),
('', 'India', 'IN'),
('', 'Indonesia', 'ID'),
('', 'Iran', 'IR'),
('', 'Iraq', 'IQ'),
('', 'Ireland', 'IE'),
('', 'Isle of Man', 'IM'),
('', 'Israel', 'IL'),
('', 'Italy', 'IT'),
('', 'Ivory Coast', 'CI'),
('', 'Jamaica', 'JM'),
('', 'Japan', 'JP'),
('', 'Jersey', 'JE'),
('', 'Jordan', 'JO'),
('', 'Kazakhstan', 'KZ'),
('', 'Kenya', 'KE'),
('', 'Kiribati', 'KI'),
('', 'Kosovo', 'XK'),
('', 'Kuwait', 'KW'),
('', 'Kyrgyzstan', 'KG'),
('', 'Laos', 'LA'),
('', 'Latvia', 'LV'),
('', 'Lebanon', 'LB'),
('', 'Lesotho', 'LS'),
('', 'Liberia', 'LR'),
('', 'Libya', 'LY'),
('', 'Liechtenstein', 'LI'),
('', 'Lithuania', 'LT'),
('', 'Luxembourg', 'LU'),
('', 'Macao', 'MO'),
('', 'Macedonia', 'MK'),
('', 'Madagascar', 'MG'),
('', 'Malawi', 'MW'),
('', 'Malaysia', 'MY'),
('', 'Maldives', 'MV'),
('', 'Mali', 'ML'),
('', 'Malta', 'MT'),
('', 'Marshall Islands', 'MH'),
('', 'Martinique', 'MQ'),
('', 'Mauritania', 'MR'),
('', 'Mauritius', 'MU'),
('', 'Mayotte', 'YT'),
('', 'Mexico', 'MX'),
('', 'Micronesia', 'FM'),
('', 'Moldova', 'MD'),
('', 'Monaco', 'MC'),
('', 'Mongolia', 'MN'),
('', 'Montenegro', 'ME'),
('', 'Montserrat', 'MS'),
('', 'Morocco', 'MA'),
('', 'Mozambique', 'MZ'),
('', 'Myanmar [Burma]', 'MM'),
('', 'Namibia', 'NA'),
('', 'Nauru', 'NR'),
('', 'Nepal', 'NP'),
('', 'Netherlands', 'NL'),
('', 'New Caledonia', 'NC'),
('', 'New Zealand', 'NZ'),
('', 'Nicaragua', 'NI'),
('', 'Niger', 'NE'),
('', 'Nigeria', 'NG'),
('', 'Niue', 'NU'),
('', 'Norfolk Island', 'NF'),
('', 'North Korea', 'KP'),
('', 'Northern Mariana Islands', 'MP'),
('', 'Norway', 'NO'),
('', 'Oman', 'OM'),
('', 'Pakistan', 'PK'),
('', 'Palau', 'PW'),
('', 'Palestine', 'PS'),
('', 'Panama', 'PA'),
('', 'Papua New Guinea', 'PG'),
('', 'Paraguay', 'PY'),
('', 'Peru', 'PE'),
('', 'Philippines', 'PH'),
('', 'Pitcairn Islands', 'PN'),
('', 'Poland', 'PL'),
('', 'Portugal', 'PT'),
('', 'Puerto Rico', 'PR'),
('', 'Qatar', 'QA'),
('', 'Republic of the Congo', 'CG'),
('', 'Réunion', 'RE'),
('', 'Romania', 'RO'),
('', 'Russia', 'RU'),
('', 'Rwanda', 'RW'),
('', 'Saint Barthélemy', 'BL'),
('', 'Saint Helena', 'SH'),
('', 'Saint Kitts and Nevis', 'KN'),
('', 'Saint Lucia', 'LC'),
('', 'Saint Martin', 'MF'),
('', 'Saint Pierre and Miquelon', 'PM'),
('', 'Saint Vincent and the Grenadines', 'VC'),
('', 'Samoa', 'WS'),
('', 'San Marino', 'SM'),
('', 'São Tomé and Príncipe', 'ST'),
('', 'Saudi Arabia', 'SA'),
('', 'Senegal', 'SN'),
('', 'Serbia', 'RS'),
('', 'Seychelles', 'SC'),
('', 'Sierra Leone', 'SL'),
('', 'Singapore', 'SG'),
('', 'Sint Maarten', 'SX'),
('', 'Slovakia', 'SK'),
('', 'Slovenia', 'SI'),
('', 'Solomon Islands', 'SB'),
('', 'Somalia', 'SO'),
('', 'South Africa', 'ZA'),
('', 'South Georgia and the South Sandwich Islands', 'GS'),
('', 'South Korea', 'KR'),
('', 'South Sudan', 'SS'),
('', 'Spain', 'ES'),
('', 'Sri Lanka', 'LK'),
('', 'Sudan', 'SD'),
('', 'Suriname', 'SR'),
('', 'Svalbard and Jan Mayen', 'SJ'),
('', 'Swaziland', 'SZ'),
('', 'Sweden', 'SE'),
('', 'Switzerland', 'CH'),
('', 'Syria', 'SY'),
('', 'Taiwan', 'TW'),
('', 'Tajikistan', 'TJ'),
('', 'Tanzania', 'TZ'),
('', 'Thailand', 'TH'),
('', 'Togo', 'TG'),
('', 'Tokelau', 'TK'),
('', 'Tonga', 'TO'),
('', 'Trinidad and Tobago', 'TT'),
('', 'Tunisia', 'TN'),
('', 'Turkey', 'TR'),
('', 'Turkmenistan', 'TM'),
('', 'Turks and Caicos Islands', 'TC'),
('', 'Tuvalu', 'TV'),
('', 'U.S. Minor Outlying Islands', 'UM'),
('', 'U.S. Virgin Islands', 'VI'),
('', 'Uganda', 'UG'),
('', 'Ukraine', 'UA'),
('', 'United Arab Emirates', 'AE'),
('', 'United Kingdom', 'GB'),
('', 'United States', 'US'),
('', 'Uruguay', 'UY'),
('', 'Uzbekistan', 'UZ'),
('', 'Vanuatu', 'VU'),
('', 'Vatican City', 'VA'),
('', 'Venezuela', 'VE'),
('', 'Vietnam', 'VN'),
('', 'Wallis and Futuna', 'WF'),
('', 'Western Sahara', 'EH'),
('', 'Yemen', 'YE'),
('', 'Zambia', 'ZM'),
('', 'Zimbabwe', 'ZW');
